# 星聚合登录 JavaScript SDK

## 使用方法

### 1. 引入SDK
```html
<script src="oauth.js"></script>
```

### 2. 初始化
```javascript
var oauth = new OAuth({
    apiurl: 'https://login.xingqingchuang.com', // 聚合登录API地址
    appid: '1000', // 应用ID
    appkey: 'xxxxxx', // 应用密钥
    callback: 'http://your-site.com/callback.html' // 回调地址
});
```

### 3. 发起登录
```javascript
// type: 登录方式，如 qq, wx, sina 等
oauth.login(type).then(function(res){
    if(res.code == 0){
        window.location.href = res.url;
    }else{
        alert(res.msg);
    }
});
```

### 4. 获取用户信息
在回调页面中：
```javascript
var code = getQueryString('code'); // 获取URL中的code参数
if(code){
    oauth.callback(code).then(function(res){
        if(res.code == 0){
            console.log(res);
            // res 包含: social_uid, nickname, faceimg, gender, etc.
        }else{
            alert(res.msg);
        }
    });
}

function getQueryString(name) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
    var r = window.location.search.substr(1).match(reg);
    if (r != null) return unescape(r[2]); return null;
}
```

## 支持的登录方式 (type)

| 平台 | 代码 (type) | 说明 |
| --- | --- | --- |
| QQ | `qq` | |
| 微信扫码 | `wx` | 开放平台 |
| 微信公众号 | `wechat` | 服务号 |
| 微博 | `sina` | |
| 支付宝 | `alipay` | |
| GitHub | `github` | |
| Google | `google` | |
| Gitee | `gitee` | |
| 百度 | `baidu` | |
| 抖音 | `douyin` | |
| 微软 | `microsoft` | |
| 小米 | `xiaomi` | |
| 钉钉 | `dingtalk` | |
| 飞书 | `feishu` | |
| Steam | `steam` | |
| X (Twitter) | `x` | |
| Facebook | `facebook` | |
| Line | `line` | |
| Apple | `apple` | |
| Instagram | `instagram` | |
| LinkedIn | `linkedin` | |
