# 星聚合登录 Python SDK

## 使用方法

### 1. 引入SDK
```python
from oauth import OAuth
```

### 2. 初始化
```python
config = {
    'apiurl': 'https://login.xingqingchuang.com', # 聚合登录API地址
    'appid': '1000', # 应用ID
    'appkey': 'xxxxxx', # 应用密钥
    'callback': 'http://your-site.com/callback' # 回调地址
}
oauth = OAuth(config)
```

### 3. 发起登录
```python
# type: 登录方式，如 qq, wx, sina 等
res = oauth.login(type)
if res['code'] == 0:
    # 跳转到 res['url']
    print(res['url'])
else:
    print(res['msg'])
```

### 4. 获取用户信息
在回调页面中：
```python
code = request.args.get('code') # 假设使用Flask，获取URL中的code参数
if code:
    res = oauth.callback(code)
    if res['code'] == 0:
        print(res)
        # res 包含: social_uid, nickname, faceimg, gender, etc.
    else:
        print(res['msg'])
```

## 支持的登录方式 (type)

| 平台 | 代码 (type) | 说明 |
| --- | --- | --- |
| QQ | `qq` | |
| 微信扫码 | `wx` | 开放平台 |
| 微信公众号 | `wechat` | 服务号 |
| 微博 | `sina` | |
| 支付宝 | `alipay` | |
| GitHub | `github` | |
| Google | `google` | |
| Gitee | `gitee` | |
| 百度 | `baidu` | |
| 抖音 | `douyin` | |
| 微软 | `microsoft` | |
| 小米 | `xiaomi` | |
| 钉钉 | `dingtalk` | |
| 飞书 | `feishu` | |
| Steam | `steam` | |
| X (Twitter) | `x` | |
| Facebook | `facebook` | |
| Line | `line` | |
| Apple | `apple` | |
| Instagram | `instagram` | |
| LinkedIn | `linkedin` | |
