# 星聚合登录 Vue SDK

## 安装

下载 `index.js` 并将其放置在您的项目中，例如 `src/utils/oauth.js`。

## 使用

```javascript
import OAuth from './utils/oauth.js';

// 初始化
const oauth = new OAuth({
    apiurl: 'https://login.xingqingchuang.com',
    appid: '您的APPID',
    appkey: '您的APPKEY',
    callback: 'https://您的网站/callback',
});

// 发起登录
const login = async (type) => {
    const res = await oauth.login(type);
    if (res.code === 0) {
        window.location.href = res.url;
    } else {
        console.error(res.msg);
    }
};

// 获取用户信息 (在回调页面)
const getUserInfo = async () => {
    const code = new URLSearchParams(window.location.search).get('code');
    if (code) {
        const res = await oauth.callback(code);
        if (res.code === 0) {
            console.log('用户信息', res);
        }
    }
};
```

## 支持的登录方式 (type)

| 平台 | 代码 (type) | 说明 |
| --- | --- | --- |
| QQ | `qq` | |
| 微信扫码 | `wx` | 开放平台 |
| 微信公众号 | `wechat` | 服务号 |
| 微博 | `sina` | |
| 支付宝 | `alipay` | |
| GitHub | `github` | |
| Google | `google` | |
| Gitee | `gitee` | |
| 百度 | `baidu` | |
| 抖音 | `douyin` | |
| 微软 | `microsoft` | |
| 小米 | `xiaomi` | |
| 钉钉 | `dingtalk` | |
| 飞书 | `feishu` | |
| Steam | `steam` | |
| X (Twitter) | `x` | |
| Facebook | `facebook` | |
| Line | `line` | |
| Apple | `apple` | |
| Instagram | `instagram` | |
| LinkedIn | `linkedin` | |
